﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class AmbientAudio : MonoBehaviour
{
    [SerializeField]
    public AudioClip[] AudioClips;

    public int AmbientChance;

    /// <summary>
    /// Returns a boolean representing whether or not an ambient audio clip should or should not play
    /// </summary>
    /// <returns>A boolean representing whether or not an ambient audio clip should or should not play</returns>
    public bool ShouldPlay()
    {
        //Generate value between 1 and 100, return if less than or equal to the chance
        System.Random rand = new System.Random(Guid.NewGuid().GetHashCode());
        int val = rand.Next(1, 100);
        return val <= AmbientChance;
    }

    /// <summary>
    /// Performs safety checks and then picks and plays a random ambient audio sound from the array of clips
    /// </summary>
    public void PlayAmbientAudio()
    {
        if (AudioClips != null && AudioClips.Length > 0 && AudioManager.Instance != null)
        {
            //Generate a random index in the clips array, play the clip at that index
            System.Random rand = new System.Random(Guid.NewGuid().GetHashCode());
            int index = rand.Next(0, AudioClips.Length - 1);
            AudioManager.Instance.PlaySFX(AudioClips[index]);
        }
    }
}
